% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SomaDataIO-package.R
\docType{package}
\name{SomaDataIO-package}
\alias{SomaDataIO}
\alias{SomaDataIO-package}
\title{SomaDataIO: Input/Output 'SomaScan' Data}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Load and export 'SomaScan' data via the 'SomaLogic Operating Co., Inc.' structured text file called an ADAT ('*.adat'). For file format see \url{https://github.com/SomaLogic/SomaLogic-Data/blob/main/README.md}. The package also exports auxiliary functions for manipulating, wrangling, and extracting relevant information from an ADAT object once in memory.
}
\details{
Load an ADAT file into the global workspace with a call
to \code{\link[=read_adat]{read_adat()}}. This function parses the main data
table into a \code{data.frame} object and assigns the remaining data from
the file as object \code{attributes}, i.e. call \code{attributes(adat)}.
Other functions in the package are designed to make extracting,
manipulating, and wrangling data in the newly created \link{soma_adat}
object more convenient.

Those familiar with micro-array data analysis and associated packages, e.g.
\pkg{Biobase}, will notice that the feature data (proteins) are arranged as
columns and the samples (arrays) are the rows. This is the
transpose of typical micro-array data. This conflict can be easily solved
using the transpose function, \code{\link[=t]{t()}}, which is part of the \verb{base R}.
In addition, those familiar with the standard \code{ExpressionSet} object,
available from \code{Bioconductor}, might find the functions \code{\link[=adat2eSet]{adat2eSet()}} and
\code{\link[=pivotExpressionSet]{pivotExpressionSet()}} particularly useful.
}
\examples{
# a listing of all pkg functions
library(help = SomaDataIO)

# the `soma_adat` class
class(example_data)
is.soma_adat(example_data)

# Annotations Lookup Table
anno_tbl <- getAnalyteInfo(example_data)
anno_tbl

# Find all analytes starting with "MMP" in `anno_tbl`
dplyr::filter(anno_tbl, grepl("^MMP", Target))
}
\seealso{
Useful links:
\itemize{
  \item \url{https://somalogic.github.io/SomaDataIO/}
  \item \url{https://somalogic.com}
  \item Report bugs at \url{https://github.com/SomaLogic/SomaDataIO/issues}
}

}
\author{
\strong{Maintainer}: Caleb Scheidel \email{calebjscheidel@gmail.com}

Authors:
\itemize{
  \item Stu Field \email{stu.g.field@gmail.com} (\href{https://orcid.org/0000-0002-1024-5859}{ORCID})
}

Other contributors:
\itemize{
  \item SomaLogic Operating Co., Inc. [copyright holder, funder]
}

}
\keyword{internal}
\keyword{package}
