% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getChildTaxa.R
\name{getChildTaxa}
\alias{getChildTaxa}
\title{Get the lower (child) taxa for a taxon name or code}
\usage{
getChildTaxa(
  taxon = NULL,
  code = NULL,
  convert = TRUE,
  level = c("order", "suborder", "greatgroup", "subgroup")
)
}
\arguments{
\item{taxon}{A character vector of taxa (case-insensitive)}

\item{code}{A character vector of taxon codes (case sensitive)}

\item{convert}{Convert results from taxon codes to taxon names? Default: TRUE}

\item{level}{Filter results to specific level? Default: \code{"order"},\code{"suborder"},\code{"greatgroup"},\code{"subgroup"}}
}
\value{
A named list, where names are taxon codes and values are character vectors representing parent taxa
}
\description{
Get the lower (child) taxa for a taxon name or code
}
\examples{

# suborder children of "Mollisols"
getChildTaxa("Mollisols", level = "suborder")

# get all children within a great group, given a subgroup
getChildTaxa(getTaxonAtLevel("Ultic Haploxeralfs", "greatgroup"))

}
