% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_remove_empty_features.R
\name{remove_empty_features}
\alias{remove_empty_features}
\title{Removes variables with no necessary information from a \link{data.frame}}
\usage{
remove_empty_features(
  all.features,
  dataset,
  percentage_NA_allowed = NA,
  bandwidth = (.Machine$double.eps^0.5),
  verbose = FALSE
)
}
\arguments{
\item{all.features}{a character vector with all column names of \code{dataset} that should be
considered by the function}

\item{dataset}{the dataset as a \link{data.frame}}

\item{percentage_NA_allowed}{the percentage of missing values per vector that should be allowed without removing the feature.
All features with NA values that are higher than this level are excluded.}

\item{bandwidth}{The length of the interval that values of variable must exceed to be not
removed. By default, half of \code{.Machine$double.eps} is used.}

\item{verbose}{boolean if debug messages should be printed when a variable is removed
from the list (uses \link[futile.logger]{flog.debug})}
}
\value{
a vector of variable names that are not considered as empty
}
\description{
Removes variable names from a list of variables that contain only, or a large
portion of, \link{NA} values or have zero bandwidth (if they are numeric)
and returns the variable names.
}
\details{
The function checks all given column names for the portion of \link{NA} values.
If the number of \link{NA} of \link{Inf} exceeds \code{percentage_NA_allowed},
the column name is removed from the variable set. Besides, all numeric
variables are checked if they have almost zero \code{bandwidth}, are removed.
}
\seealso{
\link{naInf_omit}, \link{replaceNAsFeatures}
}
\author{
Konstantin Hopf \email{konstantin.hopf@uni-bamberg.de}
}
