% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pheatmap.R
\name{plot.pheatmap}
\alias{plot.pheatmap}
\title{Plot Method for pheatmap Objects}
\usage{
\method{plot}{pheatmap}(x, ...)
}
\arguments{
\item{x}{A pheatmap object, typically from \code{cluster_results$Heatmap_plot}}

\item{...}{Additional arguments (currently ignored)}
}
\value{
Invisibly returns the input pheatmap object after displaying it
}
\description{
This S3 method allows pheatmap objects (returned by \code{Celltype_Calculate()})
to be plotted using the generic \code{plot()} function. Without this method,
attempting to use \code{plot()} on a pheatmap object results in an error.
}
\details{
Pheatmap objects contain a gtable component that needs to be drawn using
grid graphics. This method handles that automatically when \code{plot()} is called.

Alternative ways to display pheatmaps:
\itemize{
\item \code{print(pheatmap_object)} - Works natively
\item \code{plot(pheatmap_object)} - Works after loading SlimR
\item \code{grid::grid.draw(pheatmap_object$gtable)} - Direct access
}
}
\examples{
\dontrun{
# After running Celltype_Calculate()
cluster_results <- Celltype_Calculate(
    seurat_obj = sce,
    gene_list = Markers_list,
    species = "Human"
)

# Now both of these work:
print(cluster_results$Heatmap_plot)
plot(cluster_results$Heatmap_plot)
}

}
