% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune.R
\name{tune_sb_gamlss}
\alias{tune_sb_gamlss}
\title{Tune select engines/penalties via a small stability run}
\usage{
tune_sb_gamlss(
  config_grid,
  base_args,
  score_lambda = 0,
  B_small = 30,
  metric = c("stability", "deviance"),
  K = 3,
  progress = TRUE
)
}
\arguments{
\item{config_grid}{a list of named lists, each containing a subset of sb_gamlss args
(e.g., list(engine="grpreg", engine_sigma="sgl", grpreg_penalty="grLasso", sgl_alpha=0.9))}

\item{base_args}{a named list of arguments passed to \code{sb_gamlss()} common to all configs}

\item{score_lambda}{Numeric; complexity penalty weight for stability metric.}

\item{B_small}{number of bootstraps to use during tuning (defaults to 30)}

\item{metric}{Character; \code{"stability"} or \code{"deviance"} (K-fold CV).}

\item{K}{Integer; folds for deviance CV.}

\item{progress}{Logical; show progress bar across configs.}
}
\value{
a list: best_config, scores (data.frame), and the fitted sb_gamlss object for the best config.
}
\description{
Evaluates a grid of configurations and picks the one maximizing a stability-based score,
optionally penalized by complexity. Designed to be lightweight and robust.
}
