% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SelectBoost.gamlss-package.R
\docType{package}
\name{SelectBoost.gamlss-package}
\alias{SelectBoost.gamlss-package}
\alias{SelectBoost.gamlss}
\title{SelectBoost.gamlss: Stability-Selection via Correlated Resampling for 'GAMLSS' Models}
\description{
Extends the 'SelectBoost' approach to Generalized Additive Models for Location, Scale and Shape (GAMLSS). Implements bootstrap stability-selection across parameter-specific formulas (mu, sigma, nu, tau) via gamlss::stepGAIC(). Includes optional standardization of predictors and helper functions for corrected AIC calculation. More details can be found in Bertrand and Maumy (2024) \url{https://hal.science/hal-05352041} that highlights correlation-aware resampling to improve variable selection for GAMLSS and quantile regression when predictors are numerous and highly correlated.
}
\examples{
\dontshow{if (requireNamespace("gamlss.dist", quietly = TRUE)) withAutoprint(\{ # examplesIf}
set.seed(1)
dat <- data.frame(
  y = gamlss.dist::rNO(80, mu = 0),
  x1 = rnorm(80),
  x2 = rnorm(80)
)
fit <- SelectBoost_gamlss(
  y ~ 1,
  data = dat,
  family = gamlss.dist::NO(),
  mu_scope = ~ x1 + x2,
  B = 10,
  pi_thr = 0.6,
  trace = FALSE
)
fit$final_formula
\dontshow{\}) # examplesIf}
}
\references{
Bertrand, F. and Maumy, M. (2024). \emph{An Improvement for Variable Selection for
Generalized Additive Models for Location, Shape and Scale and Quantile
Regression}. Joint Statistics Meetings (JSM) 2024, Portland, OR. Presented the
SelectBoost approach for GAMLSS and quantile regression, emphasizing
correlation-aware resampling to improve recall and precision when predictors
are numerous and highly correlated.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://fbertran.github.io/SelectBoost.gamlss/}
  \item \url{https://github.com/fbertran/SelectBoost.gamlss}
  \item Report bugs at \url{https://github.com/fbertran/SelectBoost.gamlss/issues}
}

}
\author{
This package was written by Frederic Bertrand.
Maintainer: Frederic Bertrand \href{mailto:frederic.bertrand@lecnam.net}{frederic.bertrand@lecnam.net}
}
\keyword{internal}
