% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interval_fastboost.R
\name{sb_beta_interval}
\alias{sb_beta_interval}
\title{SelectBoost workflow for interval responses}
\usage{
sb_beta_interval(
  X,
  Y_low,
  Y_high,
  selector = betareg_step_aic,
  sample = c("uniform", "midpoint"),
  Y = NULL,
  ...
)
}
\arguments{
\item{X}{Numeric design matrix. Coerced with \code{\link[=as.matrix]{as.matrix()}} and normalised via
\code{\link[=sb_normalize]{sb_normalize()}}.}

\item{Y_low, Y_high}{Interval bounds in \verb{[0, 1]} paired with the rows of \code{X}
when \code{interval} is not \code{"none"}.}

\item{selector}{Selection routine. Defaults to \code{\link[=betareg_step_aic]{betareg_step_aic()}}.
Function or character string. If it is a function, the selector name
should be added as the fun.name attribute.}

\item{sample}{Interval sampling scheme passed to the \code{interval} argument of
\code{\link[=sb_beta]{sb_beta()}}. \code{"uniform"} draws a pseudo-response uniformly within each
interval; \code{"midpoint"} always chooses the midpoint.}

\item{Y}{Optional point-valued response. Supply it when you wish to keep the
observed mean response but still resample within \code{Y_low}/\code{Y_high} for the
stability steps.}

\item{...}{Additional arguments forwarded to \code{selector}.}
}
\value{
See \code{\link[=sb_beta]{sb_beta()}}. The returned object carries the same
\code{"sb_beta"}-class attributes describing the correlation thresholds,
resampling diagnostics, selector, and number of replicates.
}
\description{
\code{sb_beta_interval()} forwards to \code{\link[=sb_beta]{sb_beta()}} while activating interval sampling
so that beta-regression SelectBoost runs can ingest lower/upper response
bounds directly. It mirrors \code{\link[=fastboost_interval]{fastboost_interval()}} but reuses the correlated
resampling pipeline of \code{sb_beta()}.
}
\examples{

set.seed(1)
sim <- simulation_DATA.beta(n = 120, p = 5, s = 2)
y_low <- pmax(sim$Y - 0.05, 0)
y_high <- pmin(sim$Y + 0.05, 1)
interval_fit <- sb_beta_interval(
  sim$X,
  Y_low = y_low,
  Y_high = y_high,
  B = 5,
  step.num = 0.4
)
attr(interval_fit, "interval")

}
