% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_twoOmicsData.R
\name{simulate_twoOmicsData}
\alias{simulate_twoOmicsData}
\title{Simulation of omics with predefined single or multiple latent factors in multi-omics}
\usage{
simulate_twoOmicsData(
  vector_features = c(2000, 2000),
  n_samples = 50,
  n_factors = 3,
  signal.samples = NULL,
  signal.features.one = NULL,
  signal.features.two = NULL,
  num.factor = "multiple",
  snr = 1,
  advanced_dist = NULL,
  ...
)
}
\arguments{
\item{vector_features}{A numeric vector of length two, specifying the number of features in the first and second omics datasets, respectively.}

\item{n_samples}{Integer. The number of samples shared between both omics datasets.}

\item{n_factors}{Integer. Number of latent factors to simulate.}

\item{signal.samples}{Optional numeric vector of length two: the first element is the mean, and the second is the variance of the number of signal-carrying samples per factor. If NULL, signal assignment is inferred from \code{snr}.}

\item{signal.features.one}{Optional numeric vector of length two: the first element is the mean, and the second is the variance of the number of signal-carrying features per factor in the first omic.}

\item{signal.features.two}{Optional numeric vector of length two: the first element is the mean, and the second is the variance of the number of signal-carrying features per factor in the second omic.}

\item{num.factor}{Character string. Either 'single' or 'multiple'. Determines whether to simulate a single latent factor or multiple factors.}

\item{snr}{Numeric. Signal-to-noise ratio used to estimate the background noise. The function uses this value to infer the proportion of signal versus noise in the simulated datasets.}

\item{advanced_dist}{Character string. Specifies how latent factors are distributed when \code{num.factor = 'multiple'}. Options include: '', NULL, 'mixed', 'omic.one', 'omic.two', or 'exclusive'.}

\item{...}{Additional arguments (not currently used).}
}
\description{
Simulates two high-dimensional omics datasets with customizable latent factor structures. Users can control the number and type of factors (shared, unique, mixed), the signal-to-noise ratio, and the distribution of signal-carrying samples and features. The function is flexible for benchmarking multi-omics integration methods under various controlled scenarios.
}
