% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extensionScripts.R
\name{plotConditionalMedianFunction}
\alias{plotConditionalMedianFunction}
\title{Plot the conditional median function}
\usage{
plotConditionalMedianFunction(
  yCP,
  xMed,
  yLimits = NULL,
  link = "identity",
  xlab = "Y",
  ylab = "median of X given Y",
  fs = 12,
  ybreaks = NULL,
  xbreaks = NULL
)
}
\arguments{
\item{yCP}{vector of conditioning points for the extension variable.}

\item{xMed}{vector of medians of the target variable, corresponding to
each value of the extension variable in \code{yCP}.}

\item{yLimits}{limits for the extension variable, used to set the axis limits
in the plot}

\item{link}{link in the median function. One of \code{"identity"},
\code{"log"} or \code{"logit"}.}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{fs}{font size}

\item{ybreaks}{tick marks on the y-axis}

\item{xbreaks}{tick marks on the axis}
}
\description{
Produces a plot of the conditional median function, given a set of 
conditioning points for the extension variable, a set of corresponding
medians of the target variable, given the extension variable, and a choice
of link. The identity link is the default, a log link can be used for 
non-negative target variables, and a logit link can be used for target 
variables constrained to lie between 0 and 1.
}
\examples{
\dontrun{
plotConditionalMedianFunction(yCP = c(3, 5, 7, 9.5, 13.5),
 xMed = c(2, 6.5, 9, 13, 20),
 yLimits = c(0, 20),
 link = "log")
 
plotConditionalMedianFunction(yCP = c(2, 4, 6, 8, 10),
 xMed = c(0.1, 0.3, 0.5, 0.7, 0.9),
 yLimits = c(0, 15),
 link = "logit")
 
}

}
\author{
Jeremy Oakley <j.oakley@sheffield.ac.uk>
}
