% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_catalog.R, R/get_schema.R
\name{get_catalog}
\alias{get_catalog}
\alias{get_catalog.Microsoft SQL Server}
\alias{get_schema}
\alias{get_schema.PqConnection}
\alias{get_schema.SQLiteConnection}
\title{Get the current schema/catalog of a database-related objects}
\usage{
get_catalog(obj, ...)

\method{get_catalog}{`Microsoft SQL Server`}(obj, temporary = FALSE, ...)

get_schema(obj, ...)

\method{get_schema}{PqConnection}(obj, temporary = FALSE, ...)

\method{get_schema}{SQLiteConnection}(obj, temporary = FALSE, ...)
}
\arguments{
\item{obj}{(\code{DBIConnection(1)}, \code{tbl_dbi(1)}, \code{Id(1)})\cr
The object from which to retrieve a schema/catalog.}

\item{...}{Further arguments passed to methods.}

\item{temporary}{(\code{logical(1)}) \cr
Should the reference be to the temporary schema/catalog?}
}
\value{
The catalog is extracted from \code{obj} depending on the type of input:
\itemize{
\item For \verb{get_catalog.Microsoft SQL Server}, the current database context of the connection or "tempdb" if
\code{temporary = TRUE}.
\item For \code{get_schema.tbl_dbi} the catalog is determined via \code{id()}.
\item For \verb{get_catalog.\\\\*}, \code{NULL} is returned.
}

The schema is extracted from \code{obj} depending on the type of input:
\itemize{
\item For \code{get_schema.DBIConnection()}, the current schema of the connection if \code{temporary = FALSE}.
See "Default schema" for more.
If \code{temporary = TRUE}, the temporary schema of the connection is returned.
\item For \code{get_schema.tbl_dbi()} the schema is determined via \code{id()}.
\item For \code{get_schema.Id()}, the schema is extracted from the \code{Id} specification.
}
}
\description{
Get the current schema/catalog of a database-related objects
}
\section{Default schema}{


In some backends, it is possible to modify settings so that when a schema is not explicitly stated in a query,
the backend searches for the table in this schema by default.
For Postgres databases, this can be shown with \verb{SELECT CURRENT_SCHEMA()} (defaults to \code{public}) and modified with
\verb{SET search_path TO \{ schema \}}.

For SQLite databases, a \code{temp} schema for temporary tables always exists as well as a \code{main} schema for permanent
tables. Additional databases may be attached to the connection with a named schema, but as the attachment must be
made after the connection is established, \code{get_schema} will never return any of these, as the default schema will
always be \code{main}.
}

\examples{
\dontshow{if (requireNamespace("RSQLite", quietly = TRUE)) withAutoprint(\{ # examplesIf}
  conn <- get_connection()

  dplyr::copy_to(conn, mtcars, name = "mtcars", temporary = FALSE)

  get_schema(conn)
  get_schema(get_table(conn, id("mtcars", conn = conn)))

  get_catalog(conn)
  get_catalog(get_table(conn, id("mtcars", conn = conn)))

  close_connection(conn)
\dontshow{\}) # examplesIf}
}
