% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_table.R
\name{create_table}
\alias{create_table}
\title{Create a historical table from input data}
\usage{
create_table(.data, conn = NULL, db_table, ...)
}
\arguments{
\item{.data}{(\code{data.frame(1)}, \code{tibble(1)}, \code{data.table(1)}, or \code{tbl_dbi(1)})\cr
Data object.}

\item{conn}{(\code{DBIConnection(1)})\cr
Connection object.}

\item{db_table}{(\verb{id-like object(1)})\cr
A table specification (coercible by \code{id()}).}

\item{...}{Other arguments passed to \code{\link[DBI:dbCreateTable]{DBI::dbCreateTable()}}.}
}
\value{
Invisibly returns the table as it looks on the destination (or locally if \code{conn} is \code{NULL}).
}
\description{
Create a historical table from input data
}
\examples{
\dontshow{if (requireNamespace("RSQLite", quietly = TRUE)) withAutoprint(\{ # examplesIf}
  conn <- get_connection()

  create_table(mtcars, conn = conn, db_table = "mtcars")

  close_connection(conn)
\dontshow{\}) # examplesIf}
}
