% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_imputation.R
\name{simulation_imputation_LTFU}
\alias{simulation_imputation_LTFU}
\title{Simulate Longitudinal Data with Loss to Follow-up (LTFU) for Imputation}
\usage{
simulation_imputation_LTFU(
  NNY = TRUE,
  NNX = TRUE,
  n_subject = 1000,
  seed = NULL
)
}
\arguments{
\item{NNY}{A logical value. If \code{TRUE}, the outcome \code{Y} is generated using non-normal distributions
(Skew-t random effects, t-distribution residuals). If \code{FALSE}, it uses standard Normal distributions.
Default: \code{TRUE}.}

\item{NNX}{A logical value. If \code{TRUE}, the covariates \code{X_7} through \code{X_12} are generated using
non-normal distributions (Mixture models, Skew-t random effects). If \code{FALSE}, they use standard Normal distributions.
Default: \code{TRUE}.}

\item{n_subject}{An integer specifying the number of subjects. Default: \code{1000}.}

\item{seed}{An optional integer for setting the random seed to ensure reproducibility. Default: \code{NULL}.}
}
\value{
A list containing the following components:
\describe{
\item{data_E}{A data frame of the \strong{complete} data (ground truth) without any missing values.}
\item{data_M}{A data frame of the \strong{incomplete} data, containing \code{NA}s introduced by intermittent missingness and significant LTFU.}
\item{data_O}{A duplicate of \code{data_E} used internally for generating missingness probabilities.}
\item{Z}{A matrix of random predictors (intercept and time slopes) used in generation.}
\item{pair}{A matrix summarizing the missing data pattern (generated via \code{mice::md.pattern}).}
}
}
\description{
Generates synthetic longitudinal data specifically designed to stress-test
imputation methods against \strong{Loss to Follow-up (Dropout)}. While it includes intermittent
missingness, the parameters are tuned to simulate scenarios where subjects permanently leave
the study based on their characteristics at specific time points.
}
\details{
The data generation process mirrors \code{\link{simulation_imputation}} regarding covariate structure (time-varying, non-linear, mixed types),
but utilizes specific coefficients to drive the missingness mechanisms:

\strong{1. Loss to Follow-up (LTFU):}
Dropout is simulated based on the subject's state at \strong{time point 3}. A logistic model determines the probability of dropout using:
\itemize{
\item The outcome \code{Y} at time 3.
\item Covariates \code{X_1}, \code{X_2}, and \code{X_3} at time 3.
}
If a subject is selected for LTFU, all their observations for \strong{time points 4 and 5} are set to \code{NA}.

\strong{2. Intermittent Missingness:}
Variable-specific missingness is applied to \code{X_7} through \code{X_12} using logistic models that depend on the concurrent outcome \code{Y},
other covariates, and the previous value of the variable itself (autoregressive missingness).
}
\examples{
lt_data <- simulation_imputation_LTFU(NNY = TRUE, NNX = TRUE, n_subject = 10, seed = 42)
}
