% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rsubbo}
\alias{rsubbo}
\title{Produces a random sample from a Subbotin distribution}
\usage{
rsubbo(n, m = 0, a = 1, b = 2)
}
\arguments{
\item{n}{(int) - the size of the sample.}

\item{m}{(numeric) - the location parameter.}

\item{a}{(numeric) - the scale parameter.}

\item{b}{(numeric) - the shape parameter.}
}
\value{
a numeric vector containing a random sample.
}
\description{
Generate pseudo random-number from a Subbotin distribution using the
Tadikamalla method.
}
\details{
The Subbotin distribution is given by the function:
\deqn{ f(x;a,b,m) = \frac{1}{A} e^{- \frac{1}{b} \left|\frac{x-m}{a}\right|^b} }
where \eqn{m} is a location parameter, \eqn{b} is a shape parameter, \eqn{a}
is a scale parameter and \eqn{\Gamma} represents the gamma function.
Since the Subbotin distribution is basically the exponential distribution
with scale parameter \eqn{a = ab^{1/b}} and \eqn{m=0}, we use the same
method of the exponential power RNG and add the location parameter.
Details can be found on the documentation of the \code{rpower} function.
}
\examples{
sample_gamma <- rsubbo(1000, 1, 1)
}
