% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmedois_distance.R
\name{kmedois_distance}
\alias{kmedois_distance}
\title{K-Medoids}
\usage{
kmedois_distance(data, distance, KK = 10, index = "DaviesBouldin", k = NULL)
}
\arguments{
\item{data}{Matrix with \code{dim(data)[1]} points of \code{dim(data)[2]} dimensions.}

\item{distance}{Function. This function designs how the distance is going to be calculated. It must have as input two vectors and as output the distance of these vectors.}

\item{KK}{Number. Calculates the K-Medoids  for the number of groups 2,3,...,KK. Default \code{KK=10}.}

\item{index}{Character. If \code{index="Silhouette"} the function returns the results obtained with the number of groups (between 2 and KK) that maximize the Silhouette index. If \code{index="DaviesBouldin"} the function returns the results obtained with the number of groups (between 2 and KK) that minimize the Davies Bouldin index. If \code{index="Dunn"} the function returns the results obtained with the number of groups (between 2 and KK) that maximize the Dunn index. Default: "DaviesBouldin".}

\item{k}{Number. If k is not NULL the function returns the results obtained with the K-Medoids for k groups.}
}
\value{
Returns a list with:
  \itemize{
  \item Number_of_groups: Number of groups took into account to cluster.
  \item Output_of_grouping: list with the centers and the clusters.
 \item Quality: vector with the Silhouette index, Davies Bouldin Index, the Dunn index, the Within Cluster Sum (WCS) and the time (in seconds) that the algorithm needs to be executed. The WCS is equal to the sum of the distance of each point to the center of its group.
   }
}
\description{
This function apply the K-Medoids with any distance to different number of groups and calculates quality metrics as Silhouette.
}
\examples{

set.seed(451)
data=rbind(matrix(runif(20,1,5), nrow = 2, ncol = 10),
          matrix(runif(20,20,30), nrow = 2, ncol = 10),
          matrix(runif(20,50,70), nrow = 2, ncol = 10))

kmedois_distance(data, RelativeDistance, KK=4, index="Silhouette", k=NULL)

kmedois_distance(data, RelativeDistance, k=2)

}
