#' Add one value to a vector if it is not already there
#'
#' This function adds one value to a vector if it is not already in the vector.
#'
#' @param vector Vector with values
#' @param num1 Number. Value that will be added to the vector it it is no already in it.
#'
#' @return Returns the vector with the value added if it is not already in the vector.
#'
#' @examples
#'mi_vector <- c(1, 2, 3, 4, 5)
#'num1 <- 8
#'
#'mi_vector <- add_unique_numbers2(mi_vector, num1)
#' @export
#'
#'


add_unique_numbers2 <- function(vector, num1) {
  if (!(num1 %in% vector)) {
    vector <- c(vector, num1)
  }

  return(vector)
}
