% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EEG.R
\name{EEG}
\alias{EEG}
\title{The Extended Exponential Geometric family}
\usage{
EEG(mu.link = "log", sigma.link = "log")
}
\arguments{
\item{mu.link}{defines the mu.link, with "log" link as the default for the mu parameter.}

\item{sigma.link}{defines the sigma.link, with "log" link as the default for the sigma.}
}
\value{
Returns a gamlss.family object which can be used to fit a EEG distribution in the \code{gamlss()} function.
}
\description{
The Extended Exponential Geometric family
}
\details{
The Extended Exponential Geometric distribution with parameters \code{mu} 
and \code{sigma} has density given by

\eqn{f(x)= \mu \sigma \exp(-\mu x)(1 - (1 - \sigma)\exp(-\mu x))^{-2},}

for \eqn{x > 0}, \eqn{\mu > 0} and \eqn{\sigma > 0}.
}
\examples{
# Generating some random values with
# known mu, sigma, nu and tau
y <- rEEG(n=100, mu = 1, sigma =1.5)

# Fitting the model
require(gamlss)

mod <- gamlss(y~1, sigma.fo=~1, family=EEG,
              control=gamlss.control(n.cyc=5000, trace=FALSE))

# Extracting the fitted values for mu, sigma, nu and tau
# using the inverse link function
exp(coef(mod, what='mu'))
exp(coef(mod, what='sigma'))

# Example 2
# Generating random values under some model
n <- 200
x1 <- runif(n, min=0.1, max=0.2)
x2 <- runif(n, min=0.1, max=0.15)
mu <- exp(0.75 - x1)
sigma <- exp(0.5 - x2)
x <- rEEG(n=n, mu, sigma)

mod <- gamlss(x~x1, sigma.fo=~x2, family=EEG,
              control=gamlss.control(n.cyc=5000, trace=FALSE))

coef(mod, what="mu")
coef(mod, what="sigma")
}
\references{
Almalki, S. J., & Nadarajah, S. (2014). Modifications of the 
Weibull distribution: A review. Reliability Engineering & 
System Safety, 124, 32-55.

Adamidis, K., Dimitrakopoulou, T., & Loukas, S. (2005). 
On an extension of the exponential-geometric distribution. 
Statistics & probability letters, 73(3), 259-269.
}
\seealso{
\link{dEEG}
}
\author{
Johan David Marin Benjumea, \email{johand.marin@udea.edu.co}
}
