% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{industrial_sensor}
\alias{industrial_sensor}
\title{Industrial Sensor Dataset}
\format{
A time series object of length 600 with attributes:
\describe{
\item{true_changepoints}{Vector of true changepoint locations: c(150, 300, 450)}
\item{description}{Description of the dataset}
\item{regimes}{Names of the regimes: Normal, Drift, Malfunction, Corrected}
}
}
\source{
Simulated data for package examples
}
\usage{
industrial_sensor
}
\description{
A simulated time series from a manufacturing process with abrupt changes
representing process shifts and equipment states.
}
\details{
The data simulates per-minute sensor measurements with four distinct regimes:
\itemize{
\item Regime 1 (1-150): Normal operation - mean=50, sd=2
\item Regime 2 (151-300): Process drift - mean=55, sd=2.5
\item Regime 3 (301-450): Equipment malfunction - mean=45, sd=5
\item Regime 4 (451-600): Corrected operation - mean=50, sd=1.5
}

The data includes autocorrelation typical of industrial processes.
}
\examples{
\donttest{
data(industrial_sensor)
result <- detect_regimes(industrial_sensor, method = "bocpd")
plot(result, type = "segments")
}
}
\keyword{datasets}
