% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EDR.R
\name{EDR}
\alias{EDR}
\title{Effective Detection Radius (EDR) for point transects}
\usage{
EDR(object, newdata = NULL)
}
\arguments{
\item{object}{An Rdistance model frame or fitted distance function,
normally produced by a call to \code{\link{dfuncEstim}}.}

\item{newdata}{A data frame containing new values of 
the covariates at which to evaluate the distance functions. 
If \code{newdata}
is NULL, distance functions are evaluated at values of 
the observed covariates and results in one prediction 
per distance or transect (see parameter \code{type}). 
If \code{newdata} is not NULL and the model does not contains covariates, 
this routine returns one prediction for each row in \code{newdata}, but 
columns and values in \code{newdata} are ignored.}
}
\value{
If \code{newdata} is present, the returned value is 
a vector of effective sampling distances associated with 
covariate values in \code{newdata}. Length of return 
in this case is the number of rows in \code{newdata}. 
If \code{newdata} is NULL, the returned value is a vector 
of effective sampling distances associated with covariate 
values in \code{object}. Length of return in this case 
is the number of detected groups.  The returned vector 
has measurement units, i.e., \code{object$outputUnits}.
}
\description{
Computes Effective Detection Radius (EDR) for estimated 
  detection functions on point transects.  
  See \code{\link{ESW}} is for line transects.
}
\details{
Effective Detection Radius is the integral under the 
detection function times distance. \if{latex}{I.e., 
    \deqn{EDR = \int_{w.lo}^{w.hi} xg(x)dx,} 
  where \eqn{g(x)} is the distance
  function scaled so that \eqn{g(x.scl) = g.x.scl}
  and \eqn{w.lo} and \eqn{w.hi} are the lower
  and upper truncation limits.  }
}
\examples{
# Load example thrasher data (point transect survey type)
data(thrasherDf)

# Fit half-normal detection function
dfunc <- thrasherDf |> dfuncEstim(formula=dist~bare)

# Compute effective detection radius (EDR)
EDR(dfunc) # vector length 192
effectiveDistance(dfunc) # same
EDR(dfunc, newdata = data.frame(bare=30)) # vector length 1
  
}
\seealso{
\code{\link{dfuncEstim}}, \code{\link{ESW}}, 
\code{\link{effectiveDistance}}
}
