% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppXsimd.R
\name{supportsSSE}
\alias{supportsSSE}
\title{Determine if CPU supports SSE SIMD instructions}
\usage{
supportsSSE()
}
\value{
Boolean
}
\description{
Determine if CPU supports SSE SIMD instructions
}
\examples{
\dontrun{

if (supportsSSE()) {
  Sys.setenv(PKG_CPPFLAGS = getSSEFlags())
  Rcpp::sourceCpp(verbose = TRUE, code='
    // [[Rcpp::plugins(cpp14)]]
    // [[Rcpp::depends(RcppXsimd)]]
               
    #include <Rcpp.h>
    #include "xsimd/xsimd.hpp"
               
    // [[Rcpp::export]] 
    void demoSSE42() {
      xsimd::batch<double, 2> a(1.0);
      xsimd::batch<double, 2> b(1.0);
      Rcpp::Rcout << a << " + " << b << " = " << (a + b) << std::endl;
    }')
  demoSSE42()
} else {
  message("SSE4.2 is not supported")
}
}

}
