% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc_ei_per_pt.R
\name{desc_ei_per_pt}
\alias{desc_ei_per_pt}
\title{desc_ei_per_pt}
\usage{
desc_ei_per_pt(
  df_pat_grp,
  df_pat_llt,
  language = "fr",
  order_by_freq = TRUE,
  digits = 1
)
}
\arguments{
\item{df_pat_grp}{A dataframe with two columns: id_pat and grp (the rct arm)}

\item{df_pat_llt}{A dataframe with two columns: id_pat (patient id), num_ae (AE id), llt (AE LLT), pt (AE PT), soc (AE)}

\item{language}{'fr' default or 'en'}

\item{order_by_freq}{Logical. Should PT and SOC be ordered by frequency? Defaults to TRUE. If FALSE, PT and SOC are ordered alphabetically.}

\item{digits}{Number of digits for percentages}
}
\value{
A gt table
}
\description{
A function to describe AE by soc and pt
}
\examples{
df_pat_grp <- data.frame(USUBJID = paste0("ID_", 1:10),
                         RDGRPNAME = c(rep("A", 3), rep("B", 3), rep("C", 4)))

df_pat_llt <- data.frame(USUBJID = c("ID_1", "ID_1",
                                    "ID_2",
                                    "ID_4",
                                    "ID_9"),
                         EINUM = c(1, 2, 1, 1, 1),
                         EILLTN = c("llt1", "llt1",
                                 "llt4", "llt3",
                                 "llt1"),
                         EIPTN = c("Arrhythmia", "Myocardial Infarction",
                                 "Arrhythmia", "Pneumonia",
                                 "Pneumonia"),
                         EISOCPN = c("Cardiac Disorders", "Cardiac Disorders",
                                 "Cardiac Disorders", "Infections",
                                 "Infections"))

desc_ei_per_pt(df_pat_grp = df_pat_grp,
               df_pat_llt = df_pat_llt)

}
