#' Michigan Heart Attack Mortality Data
#'
#' A dataset containing counts for Myocardial Infarction (ICD-9 code 410.0)
#' deaths in all 83 Michigan counties for individuals in 6 age groups across 10 years. This
#' dataset also contains the corresponding population counts.
#'
#' @format `miheart`
#' a list with two array objects:
#'
#' \describe{
#'   \item{Y}{death count (0-1005)}
#'   \item{n}{population count (26-292828)}
#' }
#'
#' @source <https://wonder.cdc.gov/cmf-icd9.html>
"miheart"

#' Michigan Adjacency Data
#'
#' A dataset containing the adjacency structure for each county in Michigan
#'
#' @format `miadj`
#' a list containing neighbor adjacency vectors.
"miadj"

#' Samples Generated for Michigan data
#'
#' A 4-dimensional \code{array} of samples generated by the MSTCAR Gibbs sampler for use in testing and examples
#'
#' @format `minsample`
#' a small sample dataset to be used in examples, generated by an MSTCAR model with two regions, three age groups, and three time periods.
"minsample"

#' Age- and Sex-stratified Samples for Michigan data
#'
#' A 4-dimensional \code{array} of samples generated by the MSTCAR Gibbs sampler for demonstration with \code{split_sample_groups()}
#'
#' @format `minsplit`
#' a small sample dataset to be used for demonstration with \code{split_sample_groups()}. Generated by an MSTCAR model with two regions, six age-sex groups, and three time periods.
"minsplit"

#' Michigan Shapefile
#'
#' A dataset containing U.S. Census TIGER shape data for Michigan
#'
#' @format `mishp`
#' a data frame with 83 rows and 13 variables:
#'
#' \describe{
#'   \item{STATEFP}{State FIPS code}
#'   \item{COUNTYFP}{County FIPS code}
#'   \item{COUNTYNS}{County GNIS code}
#'   \item{AFFGEOID}{Census Unique Identifier}
#'   \item{GEOID}{Census Unique Identifier, truncated}
#'   \item{NAME}{County Name}
#'   \item{NAMELSAD}{County LSAD code}
#'   \item{STUSPS}{Abbreviated State Name}
#'   \item{STATE_NAME}{State Name}
#'   \item{LSAD}{State LSAD code}
#'   \item{ALAND}{amount of land in square meters}
#'   \item{AWATER}{amount of water in square meters}
#'   \item{geometry}{shape data for each county}
#' }
#' @source <https://www.census.gov/geographies/mapping-files/time-series/geo/tiger-line-file.html>
"mishp"

#' Massachusetts Heart Attack Mortality Data
#'
#' An example dataset from CDC WONDER containing counts for Myocardial Infarction (ICD-9 code 410.0) deaths in all 14 Massachusetts counties for individuals in 2 sex groups across 3 years.
#'
#' @format `maexample`
#' a data frame with 117 rows and 10 variables:
#'
#' \describe{
#'   \item{Notes}{Dataset notes, starts at line 85}
#'   \item{Year}{Year label}
#'   \item{Year.Code}{Year label}
#'   \item{County}{County name}
#'   \item{County.Code}{County FIPS code}
#'   \item{Sex}{Sex group}
#'   \item{Sex}{Abbreviated sex group}
#'   \item{Deaths}{Death count}
#'   \item{Population}{Population count}
#'   \item{Crude.Rate}{Crude rate generated by death and population count}
#' }
#'
#' @source <https://wonder.cdc.gov/cmf-icd9.html>
"maexample"

#' Massachusetts Shapefile
#'
#' A dataset containing U.S. Census TIGER shape data for Massachusetts
#'
#' @format `mamap`
#' a data frame with 14 rows and 13 variables:
#'
#' \describe{
#'   \item{STATEFP}{State FIPS code}
#'   \item{COUNTYFP}{County FIPS code}
#'   \item{COUNTYNS}{County GNIS code}
#'   \item{AFFGEOID}{Census Unique Identifier}
#'   \item{GEOID}{Census Unique Identifier, truncated}
#'   \item{NAME}{County Name}
#'   \item{NAMELSAD}{County LSAD code}
#'   \item{STUSPS}{Abbreviated State Name}
#'   \item{STATE_NAME}{State Name}
#'   \item{LSAD}{State LSAD code}
#'   \item{ALAND}{amount of land in square meters}
#'   \item{AWATER}{amount of water in square meters}
#'   \item{geometry}{shape data for each county}
#' }
#' @source <https://www.census.gov/geographies/mapping-files/time-series/geo/tiger-line-file.html>
"mamap"
