% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PqConnection.R
\name{postgresImportLargeObject}
\alias{postgresImportLargeObject}
\title{Imports a large object from file}
\usage{
postgresImportLargeObject(conn, filepath = NULL, oid = 0)
}
\arguments{
\item{conn}{a \linkS4class{PqConnection} object, produced by
\code{\link[DBI:dbConnect]{DBI::dbConnect()}}}

\item{filepath}{a path to the large object to import}

\item{oid}{the oid to write to. Defaults to 0 which assigns an unused oid}
}
\value{
the identifier of the large object, an integer
}
\description{
Returns an object identifier (Oid) for the imported large object.
This function must be called within a transaction.
}
\examples{
\dontrun{
con <- postgresDefault()
filepath <- 'your_image.png'
dbWithTransaction(con, {
  oid <- postgresImportLargeObject(con, filepath)
})
}
}
