% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{get_lambda}
\alias{get_lambda}
\alias{get_lambda.rdmc_tuned}
\alias{get_lambda.rdmc}
\alias{get_lambda.soft_impute_tuned}
\alias{get_lambda.soft_impute}
\title{Extract the optimal value of the regularization parameter}
\usage{
get_lambda(object, ...)

\method{get_lambda}{rdmc_tuned}(object, ...)

\method{get_lambda}{rdmc}(object, relative = TRUE, ...)

\method{get_lambda}{soft_impute_tuned}(object, ...)

\method{get_lambda}{soft_impute}(object, relative = TRUE, ...)
}
\arguments{
\item{object}{an object returned by a matrix completion algorithm with a 
regularization parameter.}

\item{\dots}{additional arguments to be passed down to methods.}

\item{relative}{logical; in case the values of the regularization parameter 
were given relative to a certain reference value computed from the data at 
hand, this allows to return the optimal value before or after multiplication 
with that reference value.}
}
\value{
The optimal value of the regularization parameter.
}
\description{
Extract the optimal value of the regularization parameter from an object 
returned by a matrix completion algorithm.
}
\examples{
# toy example derived from MovieLens 100K dataset
data("MovieLensToy")
# robust discrete matrix completion with hyperparameter tuning
set.seed(20250723)
fit <- rdmc_tune(MovieLensToy, 
                 lambda = fraction_grid(nb_lambda = 6),
                 splits = holdout_control(R = 5))
# extract optimal value of regularization parameter
get_lambda(fit)

# for more examples, see the help files of other functions for 
# matrix completion and imputation methods

}
\seealso{
\code{\link{rdmc_tune}()}, \code{\link{soft_impute_tune}()}
}
\author{
Andreas Alfons
}
\keyword{utilities}
