cv_z <- function(x, y, z, tau, lambda = NULL, nfolds=5L,
                       foldid, lam2=0.01, q=0, ...){
  ############################################################################
  ## data setup
  y <- drop(y)
  x <- as.matrix(x)
  x.row <- as.integer(NROW(x))
  if (length(y) != x.row)
    stop("x and y have different number of observations.")
  ###Now fit the nfold models and store them
  if (missing(foldid)) {
    foldid <- sample(rep(seq(nfolds), length = x.row))
  } else nfolds <- max(foldid)
  if (nfolds < 3L)
    stop("nfolds must be at least 3; nfolds = 5 recommended")
  lambda <- sort(lambda, decreasing=TRUE)
  outlist <- as.list(seq(nfolds))
  for (i in seq(nfolds)) {
    which <- foldid == i
    outlist[[i]] <- hdqr(x=x[!which, , drop=FALSE], y=z[!which],
      lambda=lambda, tau=tau, ...)
    if (outlist[[i]]$jerr != 0)
      stop(paste("Error occurs when fitting the", i, "th folder."))
  }
  cvauc <- aucpath(outlist, x, y, tau, lambda, foldid, x.row, ...)
  ## wrap up output
  cvmax <- max(cvauc, na.rm=TRUE)
  idmin <- cvauc >= cvmax
  lambda.max <- max(lambda[idmin], na.rm=TRUE)
  out <- list(lambda=lambda, cvauc=cvauc, lambda.max=lambda.max, cvmax=cvmax)
  obj <- c(out)
  # class(obj) <- "cv.kqr"
  obj
}

aucpath <- function(outlist, x, y, tau, lambda, foldid, x.row, ...){
  nfolds <- max(foldid)
  predmat <- matrix(NA, x.row, length(lambda))
  nlams <- double(nfolds)
  for (i in seq(nfolds)) {
    whichfold <- foldid == i
    fitobj <- outlist[[i]]
    preds <- predict(fitobj, x[whichfold, , drop = FALSE]) - 1
    nlami <- length(fitobj$lambda)
    predmat[whichfold, seq(nlami)] <- preds
    nlams[i] <- nlami
  }
  cvauc <- apply(predmat, 2, auc_calculation, y=y)
  cvauc
}

auc_calculation <- function(pred, y){
  rocc <- roc(as.factor(y), as.vector(pred), quiet=TRUE)$auc
  return(rocc)
}