% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgm.R
\name{dgm_conditions}
\alias{dgm_conditions}
\alias{get_dgm_condition}
\title{Return Pre-specified DGM Settings}
\usage{
dgm_conditions(dgm_name)

get_dgm_condition(dgm_name, condition_id)
}
\arguments{
\item{dgm_name}{Character string specifying the DGM type}

\item{condition_id}{which conditions should settings be returned for.}
}
\value{
A data frame containing the pre-specified settings including a
\code{condition_id} column which maps settings id to the corresponding settings.
}
\description{
This function returns the list of pre-specified settings for a given Data
Generating Mechanism (DGM).
}
\examples{
head(dgm_conditions("Carter2019"))
get_dgm_condition("Carter2019", condition_id = 1)

head(dgm_conditions("Alinaghi2018"))

head(dgm_conditions("Stanley2017"))

}
