% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDemographics.R
\name{addDateOfBirth}
\alias{addDateOfBirth}
\title{Add a column with the individual birth date}
\usage{
addDateOfBirth(
  x,
  dateOfBirthName = "date_of_birth",
  missingDay = 1,
  missingMonth = 1,
  imposeDay = FALSE,
  imposeMonth = FALSE,
  name = NULL
)
}
\arguments{
\item{x}{Table with individuals in the cdm.}

\item{dateOfBirthName}{dateOfBirth column name.}

\item{missingDay}{day of the month assigned to individuals
with missing day of birth.}

\item{missingMonth}{Month of the year assigned to individuals with missing
month of birth.}

\item{imposeDay}{TRUE or FALSE. Whether the day of the date of birth
will be considered as missing for all the individuals.}

\item{imposeMonth}{TRUE or FALSE. Whether the month of the date of birth
will be considered as missing for all the individuals.}

\item{name}{Name of the new table, if NULL a temporary table is returned.}
}
\value{
The function returns the table x with an extra column that contains
the date of birth.
}
\description{
Add a column with the individual birth date
}
\examples{
\donttest{
library(PatientProfiles)

cdm <- mockPatientProfiles(source = "duckdb")

cdm$cohort1 |>
  addDateOfBirth()

}
}
