% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoring_and_diagnosis.R
\name{calculate_ptsd_total}
\alias{calculate_ptsd_total}
\title{Calculate PTSD total score}
\usage{
calculate_ptsd_total(data)
}
\arguments{
\item{data}{A dataframe containing standardized PCL-5 item scores (output of
  rename_ptsd_columns). Each symptom should be scored on a 0-4 scale where:

\itemize{
  \item 0 = Not at all
  \item 1 = A little bit
  \item 2 = Moderately
  \item 3 = Quite a bit
  \item 4 = Extremely
}}
}
\value{
A dataframe with all original columns plus an additional column "total"
  containing the sum of all 20 symptom scores (range: 0-80)
}
\description{
Calculates the total PCL-5 (PTSD Checklist for DSM-5) score by summing all
20 symptom scores. The total score ranges from 0 to 80, with higher scores
indicating greater symptom severity.
}
\details{
Calculates the total score from PCL-5 items
}
\examples{
# Create sample data
sample_data <- data.frame(
  matrix(sample(0:4, 20 * 10, replace = TRUE),
         nrow = 10,
         ncol = 20)
)
colnames(sample_data) <- paste0("symptom_", 1:20)

# Calculate total scores
scores_with_total <- calculate_ptsd_total(sample_data)
print(scores_with_total$total)

}
