% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_classes.R
\docType{class}
\name{estimate.vpin-class}
\alias{estimate.vpin-class}
\alias{show,estimate.vpin-method}
\title{VPIN estimation results}
\usage{
\S4method{show}{estimate.vpin}(object)
}
\arguments{
\item{object}{an object of class \code{estimate.vpin}}
}
\description{
The class \code{estimate.vpin} is a blueprint for \code{S4} objects
that store the results of the \code{VPIN} estimation method using the function
\code{vpin()}.

The function show() displays a description of the
estimate.vpin object: descriptive statistics of the \code{VPIN} variable,
the set of relevant parameters, and the running time.
}
\section{Slots}{

\describe{
\item{\code{success}}{(\code{logical}) returns the value \code{TRUE} when the estimation
has succeeded, \code{FALSE} otherwise.}

\item{\code{errorMessage}}{(\code{character}) returns an error message if the \code{VPIN}
estimation has failed, and is empty otherwise.}

\item{\code{improved}}{(\code{logical}) returns the value \code{TRUE} when the model used
is the improved volume-synchronized probability of informed trading of Ke and
Lin (2017), and \code{FALSE} when the model used is the volume-synchronized
probability of informed trading of Easley et al.(2011,2012).}

\item{\code{parameters}}{(\code{numeric}) returns a numeric vector of estimation
parameters (tbSize, buckets, samplength, VBS, #days), where \code{tbSize} is the
size of timebars (in seconds); \code{buckets} is the number of buckets per average
volume day; \code{VBS} is  Volume Bucket Size (daily average volume/number of
buckets \code{buckets}); \code{samplength} is the length of the window used to estimate
\code{VPIN}; and  \verb{#days} is the number of days in the dataset.}

\item{\code{bucketdata}}{(\code{dataframe}) returns the dataframe containing detailed
information about buckets. Following the output of
\insertCite{abad2012;textual}{PINstimation}, we report for each bucket its
identifier (\code{bucket}), the aggregate buy
volume (\code{agg.bVol}), the aggregate sell volume (\code{agg.sVol}), the
absolute order imbalance (\code{AOI=|agg.bVol-agg.sVol|}),
the start time (\code{starttime}), the end time (\code{endtime}), the
duration in seconds (\code{duration}) as well as
the \code{VPIN} vector.}

\item{\code{vpin}}{(\code{numeric}) returns the vector of the volume-synchronized
probabilities of informed trading.}

\item{\code{ivpin}}{(\code{numeric}) returns the vector of the improved volume-
synchronized probabilities of informed trading as in Ke and Lin (2017).}

\item{\code{dailyvpin}}{(\code{dataframe}) returns the daily \code{VPIN} values. Two
variants are provided for any given day: \code{dvpin} corresponds to
the unweighted average of vpin values, and \code{dvpin.weighted}
corresponds to the average of vpin values weighted by bucket duration.}

\item{\code{runningtime}}{(\code{numeric}) returns the running time of the \code{VPIN}
estimation in seconds.}
}}

