% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qPGaGEV.R
\name{qPGaGEV}
\alias{qPGaGEV}
\title{The quantile function of the power Garima-generalized extreme value distribution(PGaGEV).}
\usage{
qPGaGEV(p, mu, sigma, xi, a, b, c)
}
\arguments{
\item{p}{vector of probabilities.}

\item{mu}{location parameter.\code{mu}=[-Inf,Inf].}

\item{sigma}{scale parameter number 1. \code{sigma}>0.}

\item{xi}{shape parameter number 1. \code{xi}=[-Inf,Inf].}

\item{a}{scale parameter number 2. \code{a}>0.}

\item{b}{scale parameter number 3. \code{b}>0.}

\item{c}{shape parameter number 2. \code{c}=[-Inf,Inf].}
}
\value{
the quantile values of PGaGEV distribution.
}
\description{
This function calculated the quantile values of PGaGEV distribution.
}
\details{
The quantile function of PGaGEV distribution based on the research paper in references.
}
\examples{
qPGaGEV(0.1639605,2,1,0.5,0.5,0.5,0.5)
x=c(1.2,1.3,1.4)
p <- pPGaGEV(x,2,1,0.5,0.5,0.5,0.5)
qPGaGEV(p,2,1,0.5,0.5,0.5,0.5)
}
\references{
Kittipong Klinjan, Tipat Sottiwan and Sirinapa Aryuyuen (2024).
Extreme value analysis with new generalized extreme value distributions: a case study for risk analysis on pm2.5 and pm10 in pathum thani, thailand,
Commun. Math. Biol. Neurosci. 2024, 2024:100.DOI:10.28919/cmbn/8833.
}
