% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-openrepgrid.r
\docType{data}
\name{df_construct_columns}
\alias{df_construct_columns}
\title{Sample dataframe with grid data (constructs are columns)}
\description{
This dataframe can be converted into a \code{repgrid} object via \code{\link[=importDataframe]{importDataframe()}}. The columns names are \code{elements}
followed by the constructs (\code{left_pole_1:right_pole_1} to \code{left_pole_3:right_pole_3}). The poles are separated by a
colon by default (change via arg \code{pole_sep}). The rows contain the elements' entries (element name and ratings). The
min and max of the rating scale should be passed explicitly via the args \code{rmin} and \code{rmax}. See sample data
\link{df_construct_columns}.
}
\details{
\tabular{lrrrr}{
\code{elements}  \tab \code{left_pole_1:right_pole_1} \tab \code{left_pole_2:right_pole_2} \tab \code{left_pole_3:right_pole_3} \cr
\code{element_1} \tab \code{5}                        \tab \code{3}                        \tab \code{2}                        \cr
\code{element_2} \tab \code{3}                        \tab \code{3}                        \tab \code{4}                        \cr
\code{element_3} \tab \code{1}                        \tab \code{5}                        \tab \code{2}                        \cr
\code{element_4} \tab \code{4}                        \tab \code{3}                        \tab \code{3}                        \cr
}
}
\examples{
df_construct_columns
importDataframe(df_construct_columns, format = "construct_columns", rmin = 1, rmax = 5)
}
\seealso{
\code{\link[=importDataframe]{importDataframe()}}

Other grid dataframes: 
\code{\link{df_element_columns}},
\code{\link{df_long}}
}
\concept{grid_dataframe}
\keyword{data}
