# Open Bodem Index Calculator (OBIC)

<!-- badges: start -->
[![Lifecycle: stable](https://img.shields.io/badge/lifecycle-stable-green.svg)](https://lifecycle.r-lib.org/articles/stages.html)
[![R-CMD-check](https://github.com/AgroCares/Open-Bodem-Index-Calculator/actions/workflows/check-standard.yaml/badge.svg)](https://github.com/AgroCares/Open-Bodem-Index-Calculator/actions/workflows/check-standard.yaml)
[![Codecov test coverage](https://codecov.io/gh/AgroCares/Open-Bodem-Index-Calculator/branch/master/graph/badge.svg)](https://app.codecov.io/gh/AgroCares/Open-Bodem-Index-Calculator?branch=master)
[![CRAN_Status_Badge](https://www.r-pkg.org/badges/version/OBIC)](https://cran.r-project.org/package=OBIC)
[![](https://cranlogs.r-pkg.org/badges/grand-total/OBIC)](https://cran.r-project.org/package=OBIC)
<!-- badges: end -->

This R package can be used to calculate the Open Bodem Index (OBI). 
The OBI is a tool that evaluate the soil of agricultural fields based on four main criteria: chemical, physical, biological and management. 
These four criteria consist of more than 21 indicators to get a comprehensive picture of the soil. 
More information about the Open Bodem Index can be found at [Open Bodem Index](https://openbodemindex.nl).

## Installation
```R
# Install from latest stable version from CRAN
install.packages("OBIC")

# Or install the development version from GitHub
remotes::install_github("AgroCares/Open-Bodem-Index-Calculator")

# Load the OBIC package in your script
library("OBIC")
```
Previous releases of `OBIC` can be found at `releases` section on the GitHub repository.

## Documentation
Documentation of the R functions in the OBIC package can be found [here](https://agrocares.github.io/Open-Bodem-Index-Calculator/)

## More information
The [Open Bodem Index](https://openbodemindex.nl) (OBI) is a collaboration between Wageningen UR, NMI and FarmHack in collaboration with agricultural experts. 
The Open Bodem Index Calculator is a tool used by the OBI and developed by [NMI](https://www.nmi-agro.nl/).

![Logo of NMI](https://media.licdn.com/dms/image/C560BAQEYGcm4HjNnxA/company-logo_200_200/0?e=2159024400&v=beta&t=u40rJ7bixPWB2SAqaj3KCKzJRoKcqf0wUXCdmsTDQvw)
