% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cascade.R
\name{as_cascade_wide}
\alias{as_cascade_wide}
\title{Transform wide data to cascade}
\usage{
as_cascade_wide(data, node_names = NULL)
}
\arguments{
\item{data}{\link{data.frame} or \link{matrix}, rows corresponding to nodes, 
columns to cascades. Matrix entries are the event times for each node, 
cascade pair. Missing values indicate censored observations, that is, 
nodes that did not have an event). Specify column and row names if 
cascade and node ids other than integer sequences are  desired. Note that, 
if the time column is of class date or any other special time class, it 
will be converted to an integer with `as.numeric()`.}

\item{node_names}{character, factor or numeric vector, containing names for each node. 
Optional. If not provided, node names are inferred from the provided data.}
}
\value{
An object of class \code{cascade}. This is a list containing three
    (named) elements: 
    \enumerate{
        \item \code{"node_names"} A character vector of node names.
        \item \code{"cascade_nodes"} A list with one character vector per
            cascade containing the node names in order of the events.
        \item \code{"cascade_times"} A list with one element per cascade 
            containing the event times for the nodes in \code{"cascade_names"}.
    }
}
\description{
Create a cascade object from data in wide format.
}
\details{
If data is in wide format, each row corresponds to a node and each column to
a cascade. Each cell indicates the event time for a node - cascade 
combination. If a node did not experience an event for a cascade (the node
is censored) the cell entry must be \code{NA}.
}
\examples{

data("policies")
cascades <- as_cascade_long(policies, cascade_node_name = 'statenam', 
                            event_time = 'adopt_year', cascade_id = 'policy')
wide_policies = as.matrix(cascades)
cascades <- as_cascade_wide(wide_policies)
is.cascade(cascades)

}
