% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_est_Mbinder_norm.R
\name{cluster_est_Mbinder_norm}
\alias{cluster_est_Mbinder_norm}
\title{Point estimate of the partition using a modified Binder loss function}
\usage{
cluster_est_Mbinder_norm(c, Mu, Sigma, lambda = 0, a = 1, b = a, logposterior)
}
\arguments{
\item{c}{a list of vector of length \code{n}. \code{c[[j]][i]} is
the cluster allocation of observation \code{i=1...n} at iteration
\code{j=1...N}.}

\item{Mu}{is a list of length \code{n} composed of \code{p x l} matrices.
Where \code{l} is the maximum number of components per partition.}

\item{Sigma}{is list of length \code{n} composed of arrays containing a maximum of
\code{l} \code{p x p} covariance matrices.}

\item{lambda}{is a nonnegative tunning parameter allowing further control over the distance
function. Default is 0.}

\item{a}{nonnegative constant seen as the unit cost for pairwise misclassification. Default is 1.}

\item{b}{nonnegative constant seen as the unit cost for the other kind of pairwise misclassification.
Default is 1.}

\item{logposterior}{vector of logposterior corresponding to each
partition from \code{c} used to break ties when minimizing the cost function}
}
\value{
a \code{list}:
     \item{\code{c_est}:}{ a vector of length \code{n}. Point estimate of the partition}
     \item{\code{cost}:}{ a vector of length \code{N}. \code{cost[j]} is the cost
     associated to partition \code{c[[j]]}}
     \item{\code{similarity}:}{  matrix of size \code{n x n}. Similarity matrix
     (see \code{\link{similarityMat}})}
     \item{\code{opt_ind}:}{ the index of the optimal partition
     among the MCMC iterations.}
}
\description{
Get a point estimate of the partition using a modified Binder loss function
for Gaussian components
}
\details{
Note that he current implementation only allows Gaussian components.

The modified Binder loss function takes into account the distance between
mixture components using #'the  Bhattacharyya distance.
}
\references{
JW Lau, PJ Green, Bayesian Model-Based Clustering Procedures,
\emph{Journal of Computational and Graphical Statistics}, 16(3):526-558, 2007.

DA Binder, Bayesian cluster analysis, \emph{Biometrika} 65(1):31-38, 1978.
}
\seealso{
\code{\link{similarityMat}} \code{\link{similarityMatC}}
\code{\link{similarityMat_nocostC}}
}
\author{
Chariff Alkhassim
}
