% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_est_Fmeasure.R
\name{cluster_est_Fmeasure}
\alias{cluster_est_Fmeasure}
\title{Point estimate of the partition using the F-measure as the cost function.}
\usage{
cluster_est_Fmeasure(c, logposterior)
}
\arguments{
\item{c}{a list of vector of length \code{n}. \code{c[[j]][i]} is
the cluster allocation of observation \code{i=1...n} at iteration
\code{j=1...N}.}

\item{logposterior}{a vector of logposterior corresponding to each
partition from \code{c} used to break ties when minimizing the cost function}
}
\value{
a \code{list}:
     \item{\code{c_est}:}{ a vector of length \code{n}. Point estimate of the partition}
     \item{\code{cost}:}{ a vector of length \code{N}. \code{cost[j]} is the cost
     associated to partition \code{c[[j]]}}
     \item{\code{similarity}:}{  matrix of size \code{n x n}. Similarity matrix
     (see \code{\link{similarityMat}})}
     \item{\code{opt_ind}:}{ the index of the optimal partition
     among the MCMC iterations.}
}
\description{
Get a point estimate of the partition using the F-measure as the cost function.
}
\seealso{
\code{\link{similarityMat}}
}
\author{
Francois Caron, Boris Hejblum
}
