% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_nmar_result_methods.R
\name{nmar_result_s3_parent}
\alias{nmar_result_s3_parent}
\title{Parent S3 surface for NMAR results}
\description{
Methods that apply to the parent `nmar_result` class and are not
  specific to a particular engine (e.g., EL). Engines return a child class
  (e.g., `nmar_result_el`) that inherits from `nmar_result` and may override
  or extend behavior.
}
\details{
S3 surface for base `nmar_result`


  Result objects expose a universal schema:
  - `y_hat`, `estimate_name`, `se`, `converged`.
  - `model`: list with `coefficients`, `vcov`, plus optional extras.
  - `weights_info`: list with respondent weights and trimming metadata.
  - `sample`: list with total units, respondent count, survey flag, and `design`.
  - `inference`: variance metadata (`variance_method`, `df`, diagnostic flags).
  - `diagnostics`, `meta`, and `extra` for estimator-specific details.

  New engines should populate these components in their constructors and rely
  on the `nmar_result_get_*` utilities when implementing child-specific S3
  methods.
}
\keyword{internal}
