% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wl_removal_stats.R
\name{wl_removal_stats}
\alias{wl_removal_stats}
\title{Calculate some stats about removals}
\usage{
wl_removal_stats(
  waiting_list,
  start_date = NULL,
  end_date = NULL,
  referral_index = 1,
  removal_index = 2
)
}
\arguments{
\item{waiting_list}{data.frame. A df of referral dates and removals}

\item{start_date}{Date or character (in format 'YYYY-MM-DD'); The start date
to calculate from.}

\item{end_date}{Date or character (in format 'YYYY-MM-DD'); The end date to
calculate to.}

\item{referral_index}{Index of the referral column in waiting_list.}

\item{removal_index}{Index of the removal column in waiting_list.}
}
\value{
A data.frame with the following summary statistics on
removals/capacity:

\describe{
\item{capacity_weekly}{Numeric. Mean number of removals from the waiting
list per week.}
\item{capacity_daily}{Numeric. Mean number of removals from the waiting
list per day.}
\item{capacity_cov}{Numeric. Coefficient of variation in the time between
removals from the waiting list.}
\item{removal_count}{Numeric. Total number of removals from the waiting
list over the full time period.}
}
}
\description{
Calculate some stats about removals
}
\examples{
referrals <- c.Date("2024-01-01", "2024-01-04", "2024-01-10", "2024-01-16")
removals <- c.Date("2024-01-08", NA, NA, NA)
waiting_list <- data.frame("referral" = referrals, "removal" = removals)
removal_stats <- wl_removal_stats(waiting_list)

}
