% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCmisc.R
\name{is.vec.logical}
\alias{is.vec.logical}
\title{Determine robustly whether a vector contains logical data}
\usage{
is.vec.logical(x, thresh = 0.9)
}
\arguments{
\item{x}{a vector to check for logical status}

\item{thresh}{threshold to decide that a variable is logical. NA values will
be ignored in the test. Then it looks at the proportion of values that are
successfully coerced to logical without giving 'NA'. If this threshold is
0.9, then any column where at least 90% of non-NA values can be successfully
converted to logical type, will return TRUE for this function call.}
}
\value{
returns a logical TRUE or FALSE for the logical status of x.
}
\description{
This is an improvement on base:is.logical because data may be encoded as
a different type (e.g, string, "TRUE", "FALSE") especially if imported from
a file. This does not include logical vectors coded as 0,1; such will
return FALSE with this function.
}
\examples{
numeric <- 1:10
string <- paste("one", "two", "three", "four")
logic1 <- c(TRUE,FALSE,FALSE,TRUE,FALSE,NA)
logic2 <- c("TRUE", "FALSE", "TRUE", NA, "TRUE", NA, NA, NA)
logic3 <- c("True", "False", "True", "False")
numlogic <- c(0,1,0,0,0,1,1,1,0)
is.vec.logical(numeric)
is.vec.logical(string)
is.vec.logical(logic1)
is.vec.logical(logic2)
is.vec.logical(logic3)
is.vec.logical(numlogic)
}
\author{
Nicholas Cooper
}
