% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BinToGPD.R
\name{BinToGPD}
\alias{BinToGPD}
\title{Convert multivariate binary data back to the original generalized Poisson scale}
\usage{
BinToGPD(prop.vec.bin, GPDprop, Mlocation, bin.data)
}
\arguments{
\item{prop.vec.bin}{A vector of binary probabilities}

\item{GPDprop}{Generalized Poisson distribution probability mass functions tables}

\item{Mlocation}{Indices of the medians in the vector}

\item{bin.data}{Generated multivariate binary data}
}
\value{
A list containing the multivariate generalized Poisson data and its correlation matrix
}
\description{
This function maps multivariate binary data to multivariate generalized Poisson outcomes,
preserving the original marginal distribution characteristics. Given a binary representation,
it assigns generalized Poisson values based on the original probability mass
functions and the location of the median split for each variable.
}
\examples{
# Prepare three GPD parameter vectors
GPD.lambda.vec <- c(0.1, 0.2, 0.3)
GPD.theta.vec  <- c(7, 0.7, 40)

# Compute binary probabilities, PMFs, and thresholds
p     <- calc.bin.prob.GPD(GPD.theta.vec, GPD.lambda.vec)
pvec  <- p$p
prop  <- p$prop
Mloc  <- p$Mlocation

# Use only the first two variables for demonstration
pvec.pair      <- pvec[1:2]
Mlocation.pair <- Mloc[1:2]
prop.pair      <- list(prop[[1]], prop[[2]])

# Define a 2 by2 target correlation matrix
del.next <- matrix(c(1.0, 0.3,
                     0.3, 1.0),
                   nrow = 2, byrow = TRUE)

# Simulate 100 correlated binary observations
inter_bin <- generate.binaryVar(100, pvec.pair, del.next)

# Reconstruct the GPD scaled data
Mydata <- BinToGPD(pvec.pair, prop.pair, Mlocation.pair, inter_bin)

}
