% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_rmst.R
\name{multi_rmst}
\alias{multi_rmst}
\title{Test of RMST for comparing two or more survival curves}
\usage{
multi_rmst(df, tau, method = p.adjust.methods, nboot = 500)
}
\arguments{
\item{df}{A dataframe with columns :
\itemize{
\item \code{time} : positive numbers, time-to-event;
\item \code{status} : vector of integer, 0 or 1. 0 is (right) censoring, 1 is event;
\item \code{arm} : a factor or object that can be coerced to one. The group the patient
belongs to. Must have at least two levels.
}}

\item{tau}{The truncation time, default is the lowest of the max(time) of the groups;}

\item{method}{The correction used for the p-values. Must be in \link{p.adjust.methods}.
Default is the Holm correction. Unused if number of groups equals two.}

\item{nboot}{Number of bootstrap samples;}
}
\value{
An object of class \code{multi_rmst} containing :
\itemize{
\item \code{rmst_mat} RMST estimation for each arm;
\item \code{results} A matrix. Each row represents a comparison of two curves and contains the difference
of RMST, its standard deviation, the p-value and the adjusted p-value;
\item \code{p} The p-value of the global test;
\item \code{nb_tests} The number of performed tests;
\item The parameters \code{tau}, \code{method} and \code{nboot}.
}
}
\description{
Performs the test of Restricted Mean Survival Time for two or more survival curves
by comparing the difference of areas under survival curves.
}
\details{
For each group, the Restricted Mean Survival Time at time tau (RMST(tau)) is computed as the area
under the survival curve between time 0 and tau. The test of RMST is a pairwise
multiple comparison test. For each pair of groups, it tests whether the difference
between the RMST(tau) is zero or not. If the difference is not null, then the
survival curves cannot be equal.

For exactly two groups, a single test is performed. For more than two survival curves,
it compares each survival curve to every other curves and tests the global null
hypothesis "all curves are equal" against the hypothesis "the curves are not all equal".
}
\examples{
  multi_rmst(data_under_PH, tau = 36, nboot = 300)
  multi_rmst(data_not_PH, tau = 36, method = "BH", nboot = 300)

}
\references{
Royston, P., & Parmar, M. K. (2013). Restricted mean survival time:
an alternative to the hazard ratio for the design and analysis of randomized
trials with a time-to-event outcome. BMC medical research methodology, 13, 1-15.
}
