% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simsamint.R
\name{sim_sam_int}
\alias{sim_sam_int}
\title{Simulated confidence interval of a statistic}
\usage{
sim_sam_int(
  dist = c("normal", "lognormal", "gamma", "chisquare", "cauchy", "pareto", "weibull",
    "rayleigh", "laplace", "beta", "binomial", "poisson", "negativebinomial",
    "geometric", "t", "f", "uniform"),
  pop.par,
  FUN,
  side = c("lower", "upper", "both"),
  conf.coeff = 0.95,
  range = 1,
  n = 100,
  sim.size = 1000
)
}
\arguments{
\item{dist}{The parent population distribution}

\item{pop.par}{The value of the population parameters}

\item{FUN}{The statistic as a function of random data}

\item{side}{The type of the confidence interval (both sided, only lower bound or only upper bound)}

\item{conf.coeff}{The confidence coefficient of the sampling interval}

\item{range}{It controls the length of the interval in which the boundary points are searched for. One may increase the range in case the distribution of statistic is suspected to be fat tailed.}

\item{n}{sample size}

\item{sim.size}{simulation size, increasing it will gives more accuracy.}
}
\value{
A list of class \code{"momint"} will be returned having the following components:
\describe{
\item{Method}{The Method's Name}
\item{Population.Distrbution}{The family of population distribution}
\item{Paramater}{The parameter values of the population distribution}
\item{Statistic}{The function of which the interval will be provided}
\item{Sample.Size}{The sample size}
\item{Confidence.Coefficient}{The confidence coefficient of the sampling interval}
\item{Sampling.Interval}{The estimated sampling interval}
}
}
\description{
A function that returns a sampling interval for a statistic formed from random sample of certain probability distributions. The function generates the confidence interval using Monte Carlo simulations. The results might be unreliable if the resulting statistic has fat tailed distribution.
}
\details{
The function asks the user to specify a distribution from which random sample is drawn and to specify a function of the random variables for which an approximate sampling Interval is to be provided. The function then uses Monte Carlo simulation technique to provide an approximate sampling interval of the statistic.
This function might be useful when the sampling distribution for a particular statistic is unknown, but that statistic might be useful in drawing meaningful inference. Although this function is inferior to other sophisticated techniques to deal with this problem, it might come handy for a beginner.
}
\examples{
sim_sam_int(dist="normal",pop.par=c(0,1),FUN=mean,side="both")
sim_sam_int(dist="binomial",pop.par=c(5,0.5),FUN=sum,side="lower")
}
