% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_utils.R
\name{plot_pdp}
\alias{plot_pdp}
\title{Plot Partial Dependence (PDP)}
\usage{
plot_pdp(
  analysis_object,
  feature,
  group_by = NULL,
  grid_size = 25,
  show_ice = TRUE,
  ice_n = 50,
  pdp_line_size = 1.1,
  use_test = FALSE,
  plot = TRUE
)
}
\arguments{
\item{analysis_object}{A fitted \code{wrap_object} with model results or
previously computed PDP values.}

\item{feature}{Character. The continuous feature for which the PDP should be
computed.}

\item{group_by}{Optional character. A variable used to produce grouped PDP
curves.}

\item{grid_size}{Integer. Number of points used to evaluate the PDP
(default = 25).}

\item{show_ice}{Logical. Whether to overlay ICE curves (default = TRUE).}

\item{ice_n}{Integer. Number of ICE curves to sample if \code{show_ice = TRUE}
(default = 50).}

\item{pdp_line_size}{Numeric. Line width for the PDP curve (default = 1.1).}

\item{use_test}{Logical. Compute PDP using the test set instead of the
training set (default = FALSE).}

\item{plot}{Logical. If TRUE, prints the PDP plot and returns \code{wrap_object};
if FALSE, returns the ggplot object without modifying the object.}
}
\value{
If \code{plot = TRUE}, returns the updated \code{wrap_object} and prints the PDP plot.
If \code{plot = FALSE}, returns a ggplot object containing the PDP
(and optionally ICE) visualization.
}
\description{
The \strong{plot_pdp()} function computes and visualizes
\strong{Partial Dependence Plots (PDP)} for a selected feature, following the
methodology described in \emph{Interpretable Machine Learning} by Christoph Molnar.
PDPs show the average effect of a feature on model predictions by
marginalizing over the distribution of all other features. Optionally,
Individual Conditional Expectation (ICE) curves can be added to visualize
heterogeneous effects.
}
\examples{
# After fitting model with fine_tuning(wrap_object):
# plot_pdp(wrap_object, feature = "age")
}
\references{
Molnar, C. (2022). \emph{Interpretable Machine Learning}.\cr
\url{https://christophm.github.io/interpretable-ml-book/}
}
\seealso{
\code{\link{sensitivity_analysis}}
}
