% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.mic_validation}
\alias{plot.mic_validation}
\title{Plot MIC validation results}
\usage{
\method{plot}{mic_validation}(
  x,
  match_axes = TRUE,
  add_missing_dilutions = TRUE,
  facet_wrap_ncol = NULL,
  facet_wrap_nrow = NULL,
  ...
)
}
\arguments{
\item{x}{object generated using compare_mic}

\item{match_axes}{Same x and y axis}

\item{add_missing_dilutions}{Axes will include dilutions that are not}

\item{facet_wrap_ncol}{Facet wrap into n columns by antimicrobial (optional,
only available when more than one antimicrobial in validation)}

\item{facet_wrap_nrow}{Facet wrap into n rows by antimicrobial (optional,
only available when more than one antimicrobial in validation)
represented in the data, based on a series of dilutions generated using mic_range().}

\item{...}{additional arguments}
}
\value{
ggplot object
}
\description{
Plot MIC validation results
}
\examples{
gold_standard <- c("<0.25", "8", "64", ">64")
test <- c("<0.25", "2", "16", "64")
val <- compare_mic(gold_standard, test)
plot(val)

# if the validation contains multiple antibiotics, i.e.,
ab <- c("CIP", "CIP", "AMK", "AMK")
val <- compare_mic(gold_standard, test, ab)
# the following will plot all antibiotics in a single plot (pooled results)
plot(val)
# use the faceting arguments to split the plot by antibiotic
plot(val, facet_wrap_ncol = 2)
}
