% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGDrivE-Auxiliary.R
\name{calcOmega}
\alias{calcOmega}
\title{Solve for Omega (additional genotype-specific mortality)}
\usage{
calcOmega(mu, lifespanReduction)
}
\arguments{
\item{mu}{Daily mortality probability (discrete-time hazard, called \code{muAd} in code)}

\item{lifespanReduction}{Target reduced lifespan, between 0 and 1
(target average lifespan will be \eqn{\frac{1}{\mu_{Ad}} \times lifespanReduction})}
}
\description{
Solves for root of equation of geometrically-distributed lifespan for value of omega.
}
\examples{
# reduce lifespan by 10\%
#  Example mu is an average for Aedes
newOmega <- calcOmega(mu = 0.11, lifespanReduction = 0.90)

}
