% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLR-summary.R
\name{summary.PLR}
\alias{summary.PLR}
\alias{summary.PLR_boot}
\alias{summary.PLR_cv}
\title{Summary for the penalized Lorenz regression}
\usage{
\method{summary}{PLR}(object, renormalize = TRUE, ...)
}
\arguments{
\item{object}{An object of class \code{"PLR"}. The object might also have S3 classes \code{"PLR_boot"} and/or \code{"PLR_cv"} (both inherit from class \code{"PLR"})}

\item{renormalize}{A logical value determining whether the coefficient vector should be re-normalized to match the representation where the first category of each categorical variable is omitted. Default value is TRUE}

\item{...}{Additional arguments}
}
\value{
An object of class \code{"summary.PLR"}, which contains:
\describe{
   \item{\code{call}}{The matched call.}
   \item{\code{ineq}}{A table of explained inequality metrics. The columns display the explained Gini coefficient, the Gini coefficient of the response, and the Lorenz-R2. The first row contains the results obtained by BIC.}
   \item{\code{coefficients}}{A matrix with estimated coefficients, each row corresponding to a specific coefficient. The first column contains the results obtained by BIC.}
}
If the object inherits from \code{"PLR_boot"}, \code{ineq} and \code{coefficients} also include results from bootstrap, and the class \code{"summary.PLR_boot"} is added to the output.
Similarly, if the object inherits from \code{"PLR_cv"}, \code{ineq} and \code{coefficients} also include results from cross-validation, and the class \code{"summary.PLR_cv"} is added to the output.
}
\description{
Provides a summary for an object of class \code{"PLR"}.
}
\examples{
## For examples see example(Lorenz.Reg), example(Lorenz.boot) and example(PLR.CV)

}
\seealso{
\code{\link{Lorenz.Reg}}, \code{\link{Lorenz.boot}}, \code{\link{PLR.CV}}
}
