% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_piecharts.R
\name{lm_piecharts}
\alias{lm_piecharts}
\title{Add a "piecharts" layer to a lifemap_obj object.}
\usage{
lm_piecharts(
  data = NULL,
  param,
  type = c("pie", "bar", "polar-area", "polar-radius", "auto"),
  width = 30,
  height = 30,
  opacity = 1,
  showLabels = FALSE,
  pal = "Accent",
  legend = TRUE,
  legendPosition = c("topright", "bottomright", "bottomleft", "topleft"),
  display = c("auto", "requested", "all", "leaves")
)
}
\arguments{
\item{data}{A sub dataset to use, if NULL then all of the taxids from the lifemap object given to lifemap() will be used.}

\item{param}{A column name indicating the discret variable to be represented.}

\item{type}{The type of chart to draw.}

\item{width}{The maximal width of the charts.}

\item{height}{The maximal height of the charts.}

\item{opacity}{The chart's opacity.}

\item{showLabels}{A boolean indicating whether to display the values directly on the chart or not.}

\item{pal}{The palette to be used for the charts.}

\item{legend}{A boolean indiacting whether to draw the legend or not.}

\item{legendPosition}{c("topright", "bottomright", "bottomleft", "topleft"). Where should the legend be placed.}

\item{display}{c("auto", "requested", "all", "leaves"), a string indicating how to display charts :
\itemize{
\item "auto" : the markers are displayed depending on the zoom level, by default, allow to have a lot of charts
\item "requested" : only displays the requested taxa, but all at the same time
\item "all" : displays all the taxa including all the ancestors to the root
\item "leaves" : displays only the latest (most recent) taxa
}

(WARNING : "requested", "leaves" and "auto" shouldn't be used to display more than 2000 charts as it may result in long computing time)}
}
\value{
An lm_piecharts object containing all aesthetics details for one layer of charts
}
\description{
Add a "piecharts" layer to a lifemap_obj object.
}
\examples{
data(LM_eukaryotes)

lm_piecharts(param = "Status")

lm_piecharts(data = LM_eukaryotes$df[LM_eukaryotes$df$Group \%in\% "Plants", ], param = "Status")

}
