% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedigree.r
\name{ibd}
\alias{ibd}
\title{Calculation of Identity by descent (IBD).}
\usage{
ibd(a, b, c, d, n, K, theoretical = TRUE)
}
\arguments{
\item{a}{Count of affected individuals}

\item{b}{Count of obligate carriers}

\item{c}{Count of children of either affecteds or carriers, with no children of their own}

\item{d}{Count of Trees of unaffected individuals - specifically, two sequential generations (i.e. a parent and their offspring)}

\item{n}{Count of the number of second generation progeny in a given tree.}

\item{K}{The estimate of penetrance rate.}

\item{theoretical}{Boolean indicating if the calculation should be
theoretical IBD calculation (using only d and k), or if the calculation
should use the provided n value.}
}
\value{
pi-hat value. The proportion of genome shared between individuals.
}
\description{
Use the relationship informationfrom the pedigree to
estimate of the amount of the genome they have inherited it from a
common ancestor without recombination.
}
\details{
Can do this for the total potential relatedness
in a pedigree (theoretical=TRUE),
or for the actual relatedness across collected samples (theoretical=FALSE).
For the theoretical=TRUE case, in the unaffected trees,
if we have a sample from the parent,
then the offspring do not provide any additional information
for a max IBD calculation.
This means that K does not scale with n.

For theoretical=FALSE,  sometimes we don’t have the healthy parent in an unaffected tree,
and only have a child. In this case, the IBD contribution from the child is 1/4,
and since they’re unaffected and therefore are a counter-filter,
they would contribute 1-1/4 = 3/4 to the total relatedness.
Either the parent is a non-obligate carrier, or is a non-carrier.
The probability of the children depends on which of those is true,
so we have the additional set of terms in the theoretical=FALSE logic.
}
\examples{
ibd <- ibd(3, 1, 5, 2, 1, 0.4576484)
}
