% Generated by roxygen2: do not edit by hand
\name{robust_scale}
\alias{robust_scale}
\alias{safe_sd}
\title{Utility Functions}
\usage{
robust_scale(x)

safe_sd(x, na.rm = TRUE)
}
\arguments{
\item{x}{Numeric vector}

\item{na.rm}{Logical; should NA values be removed?}
}
\value{
\code{robust_scale} returns a robust scale estimate using MAD with fallback
to IQR/1.349 and SD. Returns \code{NA_real_} if fewer than 2 values.

\code{safe_sd} returns standard deviation, guaranteed to be positive
(returns machine epsilon if zero or NA).
}
\description{
\code{robust_scale} provides MAD-based scale estimation.

\code{safe_sd} provides a guaranteed-positive standard deviation.
}
\examples{
robust_scale(rnorm(50))
robust_scale(c(1, 2, 3, 100))

safe_sd(c(5, 5, 5))
}
