% Generated by roxygen2: do not edit by hand
\name{crps_empirical}
\alias{crps_empirical}
\alias{dawid_sebastiani}
\alias{log_predictive_score}
\alias{interval_score}
\title{Proper Scoring Rules}
\usage{
crps_empirical(forecast_samples, observation)

dawid_sebastiani(observation, predicted_mean, predicted_var)

log_predictive_score(observation, predicted_mean, predicted_sd)

interval_score(observation, lower, upper, alpha = 0.1)
}
\arguments{
\item{forecast_samples}{Numeric vector of samples from forecast distribution}

\item{observation}{Single observed value}

\item{predicted_mean}{Predicted mean}

\item{predicted_var}{Predicted variance}

\item{predicted_sd}{Predicted standard deviation}

\item{lower}{Lower bound of prediction interval}

\item{upper}{Upper bound of prediction interval}

\item{alpha}{Nominal miscoverage rate (default 0.1 for 90\% interval)}
}
\value{
All functions return a single numeric value or \code{NA_real_} if inputs
are invalid.

\code{crps_empirical} returns a non-negative score (lower is better).

\code{dawid_sebastiani} returns the DS score (calibration metric).

\code{log_predictive_score} returns negative log density.

\code{interval_score} returns width plus penalties for miscoverage.
}
\description{
Proper scoring rules for evaluating probabilistic forecasts.
}
\references{
Gneiting T, Raftery AE (2007). Strictly proper scoring rules, prediction,
and estimation. Journal of the American Statistical Association 102(477):359-378.
}
\examples{
set.seed(42)
forecast <- rnorm(50, 5, 1)

crps_empirical(forecast, 5.5)
dawid_sebastiani(5.5, 5, 1)
log_predictive_score(5.5, 5, 1)
interval_score(5.5, 3, 7, alpha = 0.1)
}
