% Generated by roxygen2: do not edit by hand
\name{energy_distance}
\alias{energy_distance}
\alias{wasserstein_1d}
\alias{log_euclidean_distance}
\alias{mahalanobis_distance}
\title{Distance Metrics}
\usage{
energy_distance(x, y, max_n = NULL)

wasserstein_1d(x, y)

log_euclidean_distance(x, y)

mahalanobis_distance(sample_params, reference_mean, reference_cov)
}
\arguments{
\item{x}{First distribution (numeric vector)}

\item{y}{Second distribution (numeric vector)}

\item{max_n}{Maximum sample size before subsampling (NULL = no limit)}

\item{sample_params}{Named numeric vector of sample parameters}

\item{reference_mean}{Named numeric vector of reference means}

\item{reference_cov}{Covariance matrix of reference distribution}
}
\value{
All functions return a single non-negative numeric value or
\code{NA_real_} if insufficient data or computation fails.
}
\description{
Geometric distance metrics for comparing distributions.

\code{energy_distance} uses deterministic quantile subsampling for
large datasets (no RNG dependency).
}
\references{
Szekely GJ, Rizzo ML (2013). Energy statistics: A class of statistics based
on distances. Journal of Statistical Planning and Inference 143(8):1249-72.
}
\examples{
set.seed(42)
x <- rnorm(30, 0, 1)
y <- rnorm(30, 2, 1)

energy_distance(x, y)
wasserstein_1d(x, y)
log_euclidean_distance(exp(x), exp(y))
mahalanobis_distance(c(1, 2), c(0, 0), diag(2))
}
