% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesis.R
\name{uni_mean}
\alias{uni_mean}
\title{Find mean changes in a univariate sequence}
\usage{
uni_mean(data, beta = 10)
}
\arguments{
\item{data}{A vector or one-dimensional array.}

\item{beta}{Numeric penalty constant passed to pruned exact linear time
algorithm.}
}
\value{
A list consisting of:
\itemize{
\item \verb{$changepoints} : Indices of the changepoints detected; will return \code{integer(0)} if no changepoints are detected.
\item \verb{$method} : A \code{string} \code{"Univariate Changepoint in Mean (FKWC)"}
}
}
\description{
The \code{uni_mean()} function ranks the observations from smallest to largest,
then applies the pruned exact linear time algorithm with the penalty
parameter \code{beta} to detect changepoints.
}
\examples{
set.seed(11)
mean_test <- c(rnorm(100, mean = 0), # before change in mean
               rnorm(100, mean = 5)) # after change in mean
uni_mean(mean_test)


}
\references{
Killick, R., P. Fearnhead, and I. A. Eckley. “Optimal Detection
of Changepoints With a Linear Computational Cost.” Journal of the American
Statistical Association 107, no. 500 (2012): 1590–98.
https://doi.org/10.1080/01621459.2012.737745.
}
